/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.fmtwidgets;

import com.quantumdata.fmteditor.FmtUI;
import com.quantumdata.fmteditor.fmt.CmdValue;
import com.quantumdata.fmteditor.fmtwidgets.NamedValue;
import com.quantumdata.widgets.QDPanel;
import com.quantumdata.widgets.QDRadioButton;
import com.quantumdata.widgets.QDStdUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;

public class FmtRadioGroup
extends QDPanel {
    private CmdValue m_value;
    private QDRadioButton[] m_buttons;
    private int m_curSelection = -1;
    private boolean m_showToolTips;

    public FmtRadioGroup(String string, CmdValue cmdValue, boolean bl, boolean bl2) {
        super((LayoutManager)new BorderLayout());
        this.m_value = cmdValue;
        this.m_showToolTips = bl2;
        this.initComponents(string, bl);
    }

    private void initComponents(String string, boolean bl) {
        Serializable serializable;
        NamedValue[] namedValueArray = this.m_value.getEnumValues();
        if (namedValueArray == null) {
            return;
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        QDPanel qDPanel = new QDPanel((LayoutManager)gridBagLayout);
        if (string != null) {
            qDPanel.setBorder(FmtUI.createLoweredBorder(5));
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(1, 3, 1, 3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        if (string != null) {
            serializable = FmtUI.createLabel(string);
            ((JComponent)serializable).setForeground(QDStdUI.getActionForeground());
            gridBagLayout.setConstraints((Component)serializable, gridBagConstraints);
            qDPanel.add((Component)serializable);
        }
        gridBagConstraints.anchor = 17;
        serializable = new ButtonGroup();
        this.m_buttons = new QDRadioButton[namedValueArray.length];
        for (int i = 0; i < namedValueArray.length; ++i) {
            if (bl) {
                ++gridBagConstraints.gridy;
            } else {
                ++gridBagConstraints.gridx;
            }
            this.m_buttons[i] = new QDRadioButton(namedValueArray[i].name());
            if (this.m_showToolTips) {
                this.m_buttons[i].setToolTipText("Set " + this.m_value.getName() + " to " + namedValueArray[i].value());
            }
            ((ButtonGroup)serializable).add((AbstractButton)this.m_buttons[i]);
            gridBagLayout.setConstraints((Component)this.m_buttons[i], gridBagConstraints);
            qDPanel.add((Component)this.m_buttons[i]);
            this.m_buttons[i].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    FmtRadioGroup.this.update();
                }
            });
        }
        this.add((Component)qDPanel, "Center");
        this.selectValue(this.m_value.getInt());
    }

    private void update() {
        int n = 0;
        NamedValue[] namedValueArray = this.m_value.getEnumValues();
        for (QDRadioButton qDRadioButton : this.m_buttons) {
            if (qDRadioButton.isSelected()) {
                if (this.m_curSelection != n) {
                    this.m_value.setInt(namedValueArray[n].value());
                    this.m_curSelection = n;
                }
                return;
            }
            ++n;
        }
    }

    public void selectValue(int n) {
        NamedValue[] namedValueArray = this.m_value.getEnumValues();
        if (namedValueArray == null) {
            return;
        }
        int n2 = 0;
        for (NamedValue namedValue : namedValueArray) {
            if (namedValue.value() == n) {
                this.m_buttons[n2].setSelected(true);
                this.m_curSelection = n2;
                return;
            }
            ++n2;
        }
        this.m_buttons[0].setSelected(true);
        this.m_curSelection = 0;
        this.m_value.setInt(namedValueArray[0].value());
    }
}

